---
title: Open email attachments with Browser Isolation · Changelog
description: A new attachment section in Email Security allows you to safely
  open attachments to view and investigate.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-08-open-attachments-with-browser-isolation/
  md: https://developers.cloudflare.com/changelog/2025-05-08-open-attachments-with-browser-isolation/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Open email attachments with Browser Isolation

May 15, 2025

[Email Security](https://developers.cloudflare.com/cloudflare-one/email-security/)

You can now safely open email attachments to view and investigate them.

What this means is that messages now have a **Attachments** section. Here, you can view processed attachments and their classifications (for example, *Malicious*, *Suspicious*, *Encrypted*). Next to each attachment, a **Browser Isolation** icon allows your team to safely open the file in a **clientless, isolated browser** with no risk to the analyst or your environment.

![Attachment-RBI](https://developers.cloudflare.com/_astro/Attachment-RBI.U9Dp8dJO_ySprI.webp)

To use this feature, you must:

* Enable **Clientless Web Isolation** in your Zero Trust settings.
* Have **Browser Isolation (BISO)** seats assigned.

For more details, refer to our [setup guide](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/).

Some attachment types may not render in Browser Isolation. If there is a file type that you would like to be opened with Browser Isolation, reach out to your Cloudflare contact.

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**
