---
title: New detections released for WAF managed rulesets · Changelog
description: New Cloudflare WAF managed rulesets release to improve protection
  against attacker-controlled payloads
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-10-17-emergency-waf-release/
  md: https://developers.cloudflare.com/changelog/2025-10-17-emergency-waf-release/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## New detections released for WAF managed rulesets

Oct 17, 2025

[WAF](https://developers.cloudflare.com/waf/)

This week we introduced several new detections across Cloudflare Managed Rulesets, expanding coverage for high-impact vulnerability classes such as SSRF, SQLi, SSTI, Reverse Shell attempts, and Prototype Pollution. These rules aim to improve protection against attacker-controlled payloads that exploit misconfigurations or unvalidated input in web applications.

**Key Findings**

New detections added for multiple exploit categories:

SSRF (Server-Side Request Forgery) — new rules targeting both local and cloud metadata abuse patterns (Beta).

SQL Injection (SQLi) — rules for common patterns, sleep/time-based injections, and string/wait function exploitation across headers and URIs.

SSTI (Server-Side Template Injection) — arithmetic-based probe detections introduced across URI, header, and body fields.

Reverse Shell and XXE payloads — enhanced heuristics for command execution and XML external entity misuse.

Prototype Pollution — new Beta rule identifying common JSON payload structures used in object prototype poisoning.

PHP Wrapper Injection and HTTP Parameter Pollution detections — to catch path traversal and multi-parameter manipulation attempts.

Anomaly Header Checks — detecting CRLF injection attempts in header names.

**Impact**

These updates help detect multi-vector payloads that blend SSRF + RCE or SQLi + SSTI attacks, especially in cloud-hosted applications with exposed metadata endpoints or unsafe template rendering.

Prototype Pollution and HTTP parameter pollution rules address emerging JavaScript supply-chain exploitation patterns increasingly seen in real-world incidents.

| Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
| - | - | - | - | - | - | - |
| Cloudflare Managed Ruleset | 72f0ff933fb0492eb71cda50589f2a1d | N/A | Anomaly:Header - name - CR, LF | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 5d0377e4435f467488614170132fab7e | N/A | Generic Rules - Reverse Shell - Body | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 54e32f7f802c4a699182e8921a027008 | N/A | Generic Rules - Reverse Shell - Header | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 7cbda8dbafbc465d9b64a8f2958d0486 | N/A | Generic Rules - Reverse Shell - URI | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | b9f3420674cf481da32333dc8e0cf7ad | N/A | Generic Rules - XXE - Body | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | ad55483512f0440b81426acdbf8aab5e | N/A | Generic Rules - SQLi - Common Patterns - Header URI | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 849c0618d1674f1c92ba6f9b2e466337 | N/A | Generic Rules - SQLi - Sleep Function - Header URI | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 1b4db4c4bd0649c095c27c6cb686ab47 | N/A | Generic Rules - SQLi - String Function - Header URI | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | fa2055b84af94ba4b925f834b0633709 | N/A | Generic Rules - SQLi - WaitFor Function - Header URI | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 158177dec2504acdba1f2da201a076eb | N/A | SSRF - Local - Beta | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 98bfd6bb46074d5b8d1c4b39743a63ec | N/A | SSRF - Local - 2 - Beta | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 54e1733b10da4a599e06c6fbc2e84e2d | N/A | SSRF - Cloud - Beta | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | ecd26d61a75e46f6a4449a06ab8af26f | N/A | SSRF - Cloud - 2 - Beta | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | c16f4e133c4541f293142d02e6e8dc5b | N/A | SSTI - Arithmetic Probe - URI | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | f4fd9904e7624666b8c49cd62550d794 | N/A | SSTI - Arithmetic Probe - Header | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 5c0875604f774c36a4f9b69c659d12a6 | N/A | SSTI - Arithmetic Probe - Body | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | fae6fa37ae9249d58628e54b1a3e521e | N/A | PHP Wrapper Injection | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 9c02e585db34440da620eb668f76bd74 | N/A | PHP Wrapper Injection | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | cb67fe56a84747b8b64277dc091e296d | N/A | HTTP parameter pollution | N/A | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 443b54d984944cd69043805ee34214ef | N/A | Prototype Pollution - Common Payloads - Beta | N/A | Disabled | This is a New Detection |
