---
title: Additional detections · Cloudflare Zero Trust docs
description: "Email Security allows you to configure the following additional detections:"
lastUpdated: 2025-08-06T12:36:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/additional-detections/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/additional-detections/index.md
---

Email Security allows you to configure the following additional detections:

* Domain age
* Blank email detection
* [Automated Clearing House (ACH)](https://en.wikipedia.org/wiki/Automated_clearing_house) change from free email detection
* HTML attachment email detection

To configure additional detections:

1. Log in to [Zero Trust](https://one.dash.cloudflare.com/).
2. Select **Email Security**.
3. Select **Settings**.
4. On the **Settings** page, go to **Detection settings** > **Additional detections**, and select **Edit**.

## Configure domain age

The domain age is the time since the domain has been registered.

Because of the domain age detection, [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/trusted-domains/) can be used to create an exception to the age detection.

To configure a domain age:

1. On the **Edit additional detections** page:

   * Select **Malicious domain age**: Controls the threshold for a malicious disposition. Maximum of 100 days. It is recommended to set the **Malicious domain age** to 7 days.
   * Select **Suspicious domain age**: Controls the threshold for a suspicious disposition. Maximum of 100 days. It is recommended to set the **Suspicious domain age** between 30 and 45 days.

2. Select **Save**.

## Configure blank email detection

Blank email detection detects emails with blank bodies and assigns a default disposition. You can choose between **Malicious** and **Suspicious** as dispositions.

To enable blank email detection:

1. On the **Edit additional detections** page, enable **Blank email detection**.
2. Choose between **Malicious** and **Suspicious**.
3. Select **Save**.

## Configure ACH change from free email detection

[Automated Clearing House (ACH)](https://en.wikipedia.org/wiki/Automated_clearing_house) is a banking term related to direct deposits. ACH change from free email detection detects payroll inquiries or change requests from free email domains and assigns a default disposition. You can choose between **Malicious** and **Suspicious** as dispositions.

To enable ACH change from free email detection:

1. On the **Edit additional detections** page, enable **ACH change from free email detection**.
2. Choose between **Malicious** and **Suspicious**.
3. Select **Save**.

## Configure HTML attachment email detection

HTML attachment email detection detects HTM and HTML attachments in emails and assigns a default disposition.

To enable HTML attachment email detection:

1. On the **Edit additional detections** page, enable **HTML attachment email detection**.
2. Choose between **Malicious** and **Suspicious**.
3. Select **Save**.
