---
title: Glossary · Cloudflare Zero Trust docs
description: Review definitions for Cloudflare Zero Trust terms.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/glossary/
  md: https://developers.cloudflare.com/cloudflare-one/glossary/index.md
---

Review definitions for Cloudflare Zero Trust terms.

| Term | Definition |
| - | - |
| App Launcher | The App Launcher portal provides end users with a single dashboard to open applications secured by Cloudflare Zero Trust. |
| application | The resource protected by Cloudflare Zero Trust, which can be a subdomain, a path, or a SaaS application. |
| application token | A piece of data that grants a user access to a specific Access application for a period of time. Can be stored in a browser cookie or passed to the application in place of a normal password. |
| captive portal | A login screen shown to users when they connect to a public Wi-Fi. Captive portals typically occur in places such as airports, cafes, and hotels. |
| CGNAT IP | A unique, virtual IP address assigned to each WARP device from the `100.96.0.0/12` range. You can view the CGNAT IP for a device in **My Team** > **Devices** > **Virtual IPv4/IPv6**. |
| Cloudflare Access | Cloudflare Access replaces corporate VPNs with Cloudflare's network. It verifies attributes such as identity and device posture to grant users secure access to internal tools. |
| Cloudflare Browser Isolation | Cloudflare Browser Isolation seamlessly executes active webpage content in a secure isolated browser to protect users from zero-day attacks, malware, and phishing. |
| Cloudflare CASB | Cloudflare CASB provides comprehensive visibility and control over SaaS apps to prevent data leaks and compliance violations. It helps detect insider threats, shadow IT, risky data sharing, and bad actors. |
| Cloudflare Data Loss Prevention (DLP) | Cloudflare [Data Loss Prevention](https://www.cloudflare.com/learning/access-management/what-is-dlp/) (DLP) allows you to scan your web traffic and SaaS applications for the presence of sensitive data such as social security numbers, financial information, secret keys, and source code. |
| Cloudflare DEX | Cloudflare Digital Experience Monitoring (DEX) provides visibility into device, network, and application performance across your Zero Trust organization. |
| Cloudflare Gateway | Cloudflare Gateway is a modern next-generation firewall between your user, device, or network and the public Internet. It includes DNS filtering to inspect and apply policies to all Internet-bound DNS queries. |
| Cloudflare One | The name for Cloudflare's Secure Access Service Edge (SASE) platform, which includes Zero Trust and network services. |
| Cloudflare One Agent | The name of the Cloudflare WARP client app on iOS and Android devices. |
| Cloudflare Tunnel | Cloudflare Tunnel uses software agents (`cloudflared` or WARP Connector) to establish a secure connection between a private network and Cloudflare. |
| Cloudflare Zero Trust | Cloudflare Zero Trust provides the power of Cloudflare's global network to your internal teams and infrastructure. It empowers users with secure, fast, and seamless access to any device on the Internet. |
| cloudflared | The software powering Cloudflare Tunnel. It runs on origin servers to connect applications or private networks to Cloudflare. |
| cloudflared replica | An additional instance of `cloudflared` that points to the same Cloudflare Tunnel. It ensures that your network remains online in case a single host running `cloudflared` goes down. |
| daemon | A program that performs tasks without active management or maintenance. |
| device posture | A way to evaluate the security of a user's device, for example by verifying its serial number or checking if it has the latest software updates. |
| device profile | A collection of WARP client settings applied to a specific set of devices in your organization. |
| DNS filtering | DNS filtering uses the Domain Name System to block malicious websites and filter out harmful content, enhancing security and access control. |
| DNS location | DNS locations are a collection of DNS endpoints which can be mapped to physical entities such as offices, homes, or data centers. |
| DoH subdomain | A unique DoH subdomain for each DNS location in Cloudflare Zero Trust used in WARP client settings. |
| fleet | A fleet is a collection of user devices. All devices in a fleet have WARP installed and are connected to a [Cloudflare Zero Trust organization](https://developers.cloudflare.com/cloudflare-one/setup/#create-a-zero-trust-organization). |
| Hops | Hops refer to the stops an email makes as it travels from the sender to the recipient. |
| identity provider | An identity provider (IdP) stores and manages users' digital identities, enabling single sign-on and authentication for multiple applications. |
| initial resolved IP | A unique, ephemeral IP address that Gateway assigns to DNS queries when filtering network traffic by hostname. The IP is randomly selected from the `100.80.0.0/16` (IPv4) or `2606:4700:0cf1:4000::/64` (IPv6) range. |
| JSON web token | A compact way to securely transmit information between parties as a JSON object, often used for authentication. |
| locally-managed tunnel | A Cloudflare Tunnel that was created by running `cloudflared tunnel create <NAME>` on the command line. Tunnel configuration is stored in your local `cloudflared` directory. |
| managed network | A network location, such as an office, that is associated with a specific WARP client device profile. |
| MCP client | A Model Context Protocol (MCP) client is an AI program that can request information and receive responses from an MCP server. Examples of MCP clients include Claude Desktop, Cursor AI, and Windsurf. |
| MCP server | A web application that allows AI agents to access third-party data sources and APIs using the Model Context Protocol (MCP). For example, you can use an MCP server to connect an AI assistant to your Google Drive account. |
| MCP server portal | A web application in Cloudflare Zero Trust that serves as a gateway to multiple MCP servers. |
| MCP server tool | An integration provided by an MCP server which allows an AI agent to perform a limited set of actions on a third-party system. |
| MDM file | A Mobile Device Management (MDM) file is a configuration file that allows organizations to manage the software, settings, and certificates installed on their devices. |
| MFA | Multi-factor authentication (MFA) checks multiple aspects of a user's identity, not only their username and password, before allowing them access to an application. |
| OAuth | A protocol for authorizing users, allowing them to perform actions and view data on different platforms without sharing credentials. |
| OIDC | OpenID Connect (OIDC) is an identity authentication protocol built on top of OAuth 2.0. It is used verifying user identity and obtaining basic profile information. |
| on-ramp | Refers to a way of connecting a business network to Cloudflare. Examples of on-ramps, or ways to connect to Cloudflare, are Anycast GRE tunnels, Anycast IPsec tunnels, Cloudflare Network Interconnect (CNI), Cloudflare Tunnel, and WARP. |
| PAC file | A file containing a JavaScript function which can instruct a browser to forward traffic to a proxy server instead of directly to the destination server. |
| policy | A set of rules that regulate network activity, such as login access and website reachability. |
| Quarantine policies | Policies that block specific types of emails (usually malicious and suspicious emails), preventing emails from reaching the end-user or the next mail service provider. Emails that are quarantined are reviewed by administrators and potentially released if falsely flagged. |
| RDP | Remote Desktop Protocol (RDP) allows remote desktop connections to a computer, often used on Windows and Mac operating systems. |
| remotely-managed tunnel | A Cloudflare Tunnel that was created in Zero Trust under **Networks** > **Tunnels**. Tunnel configuration is stored in Cloudflare, which allows you to manage the tunnel from the dashboard or using the API. |
| Rule group | A set of Access rules that can be configured once and then quickly applied across many Access policies. |
| SafeSearch | SafeSearch is a feature of search engines that filters explicit or offensive content from search results. |
| SAML | Security Assertion Markup Language (SAML) enables single sign-on and authentication for multiple applications. |
| SASE | Secure Access Service Edge (SASE) is a cloud-based security model bundling networking and security functions. |
| SCIM | System for Cross-domain Identity Management (SCIM) is an open standard protocol that allows identity providers (such as Okta or Microsoft Entra ID) to synchronize user identity information with cloud applications and services. |
| seat | A unique user authenticating to an Access application or enrolling in WARP, |
| service provider (SP) | A service provider (SP) provides federated access to an application for a user from an identity provider (IdP). |
| service token | Authentication credentials generated by Cloudflare Access which enable automated systems to access protected applications. |
| session | An event generated when a user logs in to an Access application. |
| shadow IT | Shadow IT is the unsanctioned use of software, hardware, or other systems and services within an organization, often without the knowledge of that organization's information technology (IT) department.For more information, refer to the [Cloudflare Learning Center](https://www.cloudflare.com/learning/access-management/what-is-shadow-it/). |
| SMB | Secure Messaging Block (SMB) is a network file sharing protocol used for accessing files and services on a network. |
| SSH | Secure Shell (SSH) protocol allows users to connect to infrastructure remotely and execute commands. |
| SSO | Single Sign-On (SSO) is a technology that combines multiple application logins into one, requiring users to enter credentials only once. |
| target | A resource with an IP address or hostname that is reachable by Cloudflare, such as a server or web application. |
| target hostname | A label used to identify a set of targets in an Access for Infrastructure application. |
| team domain | A unique subdomain assigned to your Cloudflare account (for example, `<your-team-name>.cloudflareaccess.com`), where users will find the apps you have secured behind Cloudflare Zero Trust. |
| team name | The customizable portion of your team domain (`<your-team-name>.cloudflareaccess.com`). You can view your team name in Zero Trust under **Settings** > **Custom Pages**. |
| Terraform | An infrastructure as code software tool that allows you to deploy services from different providers using a standardized configuration syntax. |
| tunnel | A secure pathway for network traffic to flow between a device and Cloudflare's global network. |
| User risk score | Cloudflare Zero Trust user risk score ranks the likelihood of a user to introduce risk to your organization's systems and data based on the detection of security risk behaviors. Risk scores add user and entity behavior analytics (UEBA) to the Zero Trust platform. |
| User risk score level | Cloudflare Zero Trust assigns a risk score of Low, Medium or High based on detections of users' activities, posture, and settings. A user's risk score is equal to the highest-level risk behavior they trigger. |
| Virtual network | A software abstraction that allows you to logically segregate resources on a private network. Virtual networks are especially useful for exposing resources which have overlapping IP routes. |
| Virtual Private Cloud (VPC) | A secure, isolated private network hosted on public cloud infrastructure. Examples of public cloud providers include Google Cloud, AWS, and Microsoft Azure. |
| Virtual Private Network (VPN) | A tool that allows users to send and receive data across shared or public networks as if their devices were directly connected to the private network. For example, employees working from home can use a VPN to access files on the corporate network. |
| WARP client | An application that connects corporate devices to Cloudflare for private network access, advanced web filtering, and other security functions. |
| WARP Connector | An extension of the WARP client used to establish site-to-site, bidirectional, and mesh networking connectivity. WARP Connector software installs on a Linux server within a private network, which then becomes a gateway for other local networks that need to on-ramp traffic to Cloudflare. |
| Zero Trust Security | Zero Trust Security is an IT security model that requires strict identity verification for every person and device accessing resources on a network. |
