---
title: Analytics overview · Cloudflare Zero Trust docs
description: The Cloudflare One Analytics overview provides a dashboard that
  reports on how Cloudflare One is protecting your organization and networks.
lastUpdated: 2025-10-23T20:06:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/analytics/analytics-overview/
  md: https://developers.cloudflare.com/cloudflare-one/insights/analytics/analytics-overview/index.md
---

The Cloudflare One Analytics overview provides a dashboard that reports on how Cloudflare One is protecting your organization and networks.

To view the Analytics overview in [Zero Trust](https://one.dash.cloudflare.com), go to **Analytics**.

The Analytics overview includes reports and insights across the following products and categories:

* [Global status](#global-status) of your Cloudflare One organization

* [Access](#access)

* Gateway

  * [HTTP traffic](#proxy-traffic)
  * [Network traffic](#gateway-network-requests)
  * [DNS traffic](#dns-traffic)
  * [Firewall policies](#gateway-insights)

## Global status

In **Global status**, you can view a report on your organization's Cloudflare One adoption that contains the following metrics:

* Access apps configured
* Gateway HTTP policies
* Gateway network policies
* Gateway DNS policies
* SaaS integrations
* DLP profiles

You can also view a report on your [seat usage](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/seat-management/) across your Cloudflare One organization that contains the following metrics:

* Total seats
* Used seats
* Unused seats

## Access

In **Access**, you can view a report on your Access configuration that contains:

**Metrics:**

* Total access attempts
* Granted access
* Denied (policy violation)
* Active logins overtime
* Top applications with most logins

**Filters:**

* Access data by country

## Gateway

### Proxy traffic

In **Proxy traffic**, you can view a report on your Gateway HTTP traffic that contains:

**Metrics:**

* Total requests overtime
* Allowed requests
* Blocked requests
* Isolated requests
* Do not inspect requests
* Top bandwidth consumers (GB)
* Top denied users

**Filters:**

* Gateway HTTP traffic data by country

### Gateway (network requests)

In **Gateway (network requests)**, you can view a report on your Gateway network traffic that contains:

**Metrics:**

* Total sessions
* Authenticated sessions
* Blocked sessions
* Audit SSH sessions
* Allowed sessions
* Override sessions
* Top bandwidth consumers in GB
* Top denied users

**Filters:**

* Gateway network traffic data by country

### DNS traffic

In **DNS traffic**, you can view a report on your Gateway DNS traffic that contains:

**Metrics:**

* Total DNS queries
* Allowed DNS queries
* Blocked DNS queries
* Override DNS queries
* Safe Search DNS queries
* Restricted DNS queries
* Other DNS queries

**Filters:**

* Gateway DNS traffic by query type
* Gateway DNS traffic by country

### Gateway insights

In **Gateway insights**, you can view a report on your Gateway firewall policies that contains the following metrics:

* Top domain blocking policies
* Most user queries
* Top devices
* Top countries

### CASB metrics

In **CASB**, you can review instances of security issues found in your SaaS integrations.

* Integrations by number of findings
* DLP findings by profile name
