---
title: Okta (SAML) · Cloudflare Zero Trust docs
description: Integrate Okta as a SAML identity provider with Cloudflare Zero Trust.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/okta-saml/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/okta-saml/index.md
---

Cloudflare Zero Trust can integrate SAML with Okta as an identity provider.

## Set up Okta as a SAML provider

To set up SAML with Okta as your identity provider:

1. On your Okta admin dashboard, go to **Applications** > **Applications**.

2. Select **Create App Integration**.

3. In the pop-up dialog, select **SAML 2.0** and then elect **Next**.

4. Enter an app name and select **Next**.

   ![Entering your Zero Trust callback URL into Okta](https://developers.cloudflare.com/_astro/okta-saml-1.BO9WudzS_2mBicN.webp)

5. In the **Single sign on URL** and the **Audience URI (SP Entity ID)** fields, enter the following URL:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

   You can find your team name in Zero Trust under **Settings** > **Custom Pages**.

6. In the **Attribute Statements** section, enter the following information:

   * **Name**: Enter `email`.
   * **Value**: Enter `user.email`.

7. (Optional) If you are using Okta groups, create a **Group Attribute Statement** with the following information:

   * **Name**: Enter `groups`.
   * **Filter**: Select *Matches regex* and enter `.*`.

![Configuring attribute statements in Okta](https://developers.cloudflare.com/_astro/okta-saml-2.BkDiypq5_1gEsSA.webp)

1. Select **Next**.

2. Select **I'm an Okta customer adding an internal app** and check **This is an internal app that we have created**.

![Configuring feedback options in Okta](https://developers.cloudflare.com/_astro/okta-saml-3.-GrxFq28_6b1N9.webp)

1. Select **Finish**.

2. In the **Assignments** tab, select **Assign** and assign individuals or groups you want to grant access to.

3. Select **Done**. The assigned individuals and groups will display in the **Assignments** tab.

![Assigning individuals and groups to Okta application](https://developers.cloudflare.com/_astro/okta-saml-4.CrMrhldk_JD3rd.webp)

1. To retrieve the SAML provider information, go to the **Sign On** tab and select **View Setup Instructions**. A new page will open showing the **Identity Provider Single Sign-on URL**, **Identity Provider Issuer**, and **X.509 Certificate**. Save this information for configuring your Zero Trust settings.

![Retrieving SAML provider information in Okta](https://developers.cloudflare.com/_astro/okta-saml-5.CWJU56SQ_80iNi.webp)

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

2. Select **Add new** under **Login Methods**, and select *SAML*.

3. Fill in the following information:

   * **Name**: Name your identity provider.
   * **Single Sign On URL**: Enter the Identity Provider Single-Sign-On URL from Okta.
   * **Issuer ID**: Enter the Identity Provider Issuer from Okta, for example `http://www.okta.com/<your-okta-entity-id>`.
   * **Signing Certificate**: Copy-paste the X.509 Certificate from Okta.

4. (Recommended) Enable **Sign SAML authentication request**.

5. (Recommended) Under **SAML attributes**, add the `email` and `groups` attributes. The `groups` attribute is required if you want to create policies based on [Okta groups](https://developers.cloudflare.com/cloudflare-one/traffic-policies/identity-selectors/#okta-saml).

![Adding optional SAML attributes in Zero Trust](https://developers.cloudflare.com/_astro/okta-saml-6.4pq9o6NF_awYpQ.webp)

1. Select **Save**.

To test that your connection is working, go to **Settings** > **Authentication** > **Login methods** and select **Test** next to Okta. A success response should return the configured SAML attributes.

Warning

SAML attributes are only refreshed during authentications with the Okta identity provider. This means the Okta group membership is not updated unless a user logs in and out of the WARP client, or logs in to an Access application.

## Example API configuration

```json
{
  "config": {
    "issuer_url": "http://www.okta.com/exkbhqj29iGxT7GwT0h7",
    "sso_target_url": "https://dev-abc123.oktapreview.com/app/myapp/exkbhqj29iGxT7GwT0h7/sso/saml",
    "attributes": ["email", "group"],
    "email_attribute_name": "",
    "sign_request": false,
    "idp_public_certs": [
      "MIIDpDCCAoygAwIBAgIGAV2ka+55MA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEG\nA1UEC.....GF/Q2/MHadws97cZg\nuTnQyuOqPuHbnN83d/2l1NSYKCbHt24o"
    ]
  },
  "type": "saml",
  "name": "okta saml example"
}
```
