---
title: PingOne · Cloudflare Zero Trust docs
description: The PingOne cloud platform from PingIdentity provides SSO identity
  management. Cloudflare Access supports PingOne as an OIDC identity provider.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/pingone-oidc/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/pingone-oidc/index.md
---

The PingOne cloud platform from PingIdentity provides SSO identity management. Cloudflare Access supports PingOne as an OIDC identity provider.

## Set up PingOne as an OIDC provider

### 1. Create an application in PingOne

1. In your PingIdentity environment, go to **Connections** > **Applications**.

2. Select **Add Application**.

3. Enter an **Application Name**.

4. Select **OIDC Web App** and then **Save**.

5. Select **Resource Access** and add the **email** and **profile** scopes.

6. In the **Configuration** tab, select **General**.

7. Copy the **Client ID**, **Client Secret**, and **Environment ID** to a safe place. These ids will be used in a later step to add PingOne to Zero Trust.

8. In the **Configuration** tab, select the pencil icon.

9. In the **Redirect URIs** field, enter the following URL:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

   You can find your team name in Zero Trust under **Settings** > **Custom Pages**.

10. Select **Save**.

### 2. Add PingOne to Zero Trust

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Authentication**.
2. Under **Login methods**, select **Add new**.
3. Select **PingOne**.
4. Input the **Client ID**, **Client Secret**, and **Environment ID** generated previously.
5. (Optional) Enable [Proof of Key Exchange (PKCE)](https://www.oauth.com/oauth2-servers/pkce/). PKCE will be performed on all login attempts.
6. (Optional) To enable SCIM, refer to [Synchronize users and groups](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/#synchronize-users-and-groups).
7. (Optional) Under **Optional configurations**, enter [custom OIDC claims](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/#custom-oidc-claims) that you wish to add to your users' identity.
8. Select **Save**.

You can now [test your connection](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/#test-idps-in-zero-trust) and create [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) based on the configured login method.

## Example API configuration

```json
{
  "config": {
    "client_id": "<your client id>",
    "client_secret": "<your client secret>",
    "ping_env_id": "<your ping environment id>"
  },
  "type": "ping",
  "name": "my example idp"
}
```
