---
title: PingOne (SAML) · Cloudflare Zero Trust docs
description: Learn how to integrate PingOne as a SAML identity provider with
  Cloudflare Zero Trust.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/pingone-saml/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/pingone-saml/index.md
---

The PingOne cloud platform from PingIdentity provides SSO identity management. Cloudflare Access supports PingOne as a SAML identity provider.

## Set up PingOne as a SAML provider

## 1. Create an application in PingOne

1. In your PingIdentity environment, go to **Connections** > **Applications**.

2. Select **Add Application**.

3. Enter an **Application Name**.

4. Select **SAML Application**.

5. Select **Configure**.

6. To fill in your Cloudflare Access metadata:

   1. Select **Import from URL**.
   2. Set the **Import URL** to:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/saml-metadata
   ```

   where `<your-team-name>` is your Cloudflare Zero Trust team name. 3. Select **Import**. 4. **Save** the configuration.

7. In the **Configuration** tab, select **Download metadata** and save the XML metadata file. This file will be used in a later step to add PingOne to Zero Trust.

8. In the **Attribute Mappings** tab, add the following required attributes (case sensitive) and select **Save**.

   | Application attribute | Outgoing value |
   | - | - |
   | `email` | Email Address |
   | `givenName` | Given Name |
   | `surName` | Family Name |

   These [SAML attributes](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/#saml-attributes) tell Cloudflare Access who the user is.

9. Set the application to **Active**.

### 2. Add PingOne to Zero Trust

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Authentication**.

2. Under **Login methods**, select **Add new**.

3. Select **SAML**.

4. Upload your PingOne XML metadata file.

5. (Optional) To enable SCIM, refer to [Synchronize users and groups](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/#synchronize-users-and-groups).

6. (Optional) Under **Optional configurations**, configure [additional SAML options](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/#optional-configurations).

7. Select **Save**.

You can now [test your connection](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/#test-idps-in-zero-trust) and create [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) based on the configured login method and SAML attributes.
