---
title: SentinelOne - Posture checks · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust can integrate with SentinelOne to require
  that users connect to certain applications from managed devices. This
  service-to-service posture check uses the WARP client to read endpoint data
  from SentinelOne. Devices are identified by their serial numbers. If multiple
  devices have the same serial number, Cloudflare cannot accurately match a WARP
  device with a third-party provider device. You must ensure that each of your
  devices has a unique serial number.
lastUpdated: 2025-10-23T02:03:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/sentinelone/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/sentinelone/index.md
---

Cloudflare Zero Trust can integrate with SentinelOne to require that users connect to certain applications from managed devices. This service-to-service posture check uses the WARP client to read endpoint data from SentinelOne. Devices are identified by their serial numbers. If multiple devices have the same serial number, Cloudflare cannot accurately match a WARP device with a third-party provider device. You must ensure that each of your devices has a unique serial number.

## Prerequisites

* SentinelOne agent is deployed on the device.

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [Service providers](https://developers.cloudflare.com/cloudflare-one/integrations/service-providers/).

## Set up SentinelOne as a service provider

### 1. Obtain SentinelOne settings

The following SentinelOne values are needed to set up the SentinelOne posture check:

* API Token
* REST API URL

To retrieve those values:

1. Log in to your SentinelOne Dashboard.
2. Go to **Settings** > **Users** > **Create new Service User**.
3. Select **Create New Service User**.
4. Enter a **Name** and **Expiration Date** and select **Next**.
5. Set **Scope of Access** to *Viewer*.
6. Select **Create User**. SentinelOne will generate an API Token for this user.
7. Copy the **API Token** to a safe location.
8. Select **Close**.
9. Copy the **Rest API URL** from your browser's address bar (for example, `https://<S1-DOMAIN>.sentinelone.net`).

### 2. Add SentinelOne as a service provider

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **Third-party service provider integrations** and select **Add new**.
3. Select **SentinelOne**.
4. Enter any name for the provider. This name will be used throughout the dashboard to reference this connection.

1) In **Client Secret**, enter your **API Token**.
2) In **Rest API URL**, enter `https://<S1-DOMAIN>.sentinelone.net`.
3) Choose a **Polling frequency** for how often Cloudflare Zero Trust should query SentinelOne for information.
4) Select **Test and save**.

### 3. Configure the posture check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client** > **Service provider checks**.
2. Select **Add new**.
3. Select the SentinelOne provider.
4. Enter any name for the posture check.
5. Configure the [attributes](#device-posture-attributes) required for the device to pass the posture check.
6. Select **Save**.
7. To test, go to **Logs** > **Posture** and verify that the service provider posture check is returning the expected results.

You can now use this posture check in a [device posture policy](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/#3-build-a-device-posture-policy).

## Device posture attributes

Device posture data is gathered from the SentinelOne Management APIs. For more information, refer to `https://<S1-DOMAIN>.sentinelone.net/api-doc/overview`.

| Selector | Description |
| - | - |
| Infected | Whether the device is infected |
| Active Threats | Number of active threats on the device |
| Is Active | Whether the SentinelOne Agent is active |
| Network status | Whether the SentinelOne Agent is connected to the SentinelOne service |
| Operational State | The [operational state](https://community.sentinelone.com/s/login/?ec=302\&startURL=%2Fs%2Farticle%2F000005285) of the SentinelOne Agent. |

### Detect user risk behavior

SentinelOne provides endpoint detection and response (EDR) signals to determine [user risk score](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/). User risk scores allow you to detect users that present security risks to your organization. For more information, refer to [Predefined risk behaviors](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/#predefined-risk-behaviors).
