---
title: Tunnel with firewall · Cloudflare Zero Trust docs
description: You can implement a positive security model with Cloudflare Tunnel
  by blocking all ingress traffic and allowing only egress traffic from
  cloudflared. Only the services specified in your tunnel configuration will be
  exposed to the outside world.
lastUpdated: 2025-10-23T20:06:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/tunnel-with-firewall/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/tunnel-with-firewall/index.md
---

You can implement a positive security model with Cloudflare Tunnel by blocking all ingress traffic and allowing only egress traffic from `cloudflared`. Only the services specified in your tunnel configuration will be exposed to the outside world.

## Ports

The parameters below can be configured for egress traffic inside of a firewall.

How you configure your firewall depends on the firewall type:

* If your firewall supports domain-based rules (FQDN allowlists), you can allow outbound connections to the hostnames listed below.
* If your firewall requires IP-based rules, allow outbound connections to all listed IP addresses for each domain.

Ensure port `7844` is allowed for both TCP and UDP protocols (for `http2` and `quic`).

### Required for tunnel operation

`cloudflared` connects to Cloudflare's global network on port `7844`. To use Cloudflare Tunnel, your firewall must allow outbound connections to the following destinations on port `7844` (via UDP if using the `quic` protocol or TCP if using the `http2` protocol).

#### `region1.v2.argotunnel.com`

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| `198.41.192.167` `198.41.192.67` `198.41.192.57` `198.41.192.107` `198.41.192.27` `198.41.192.7` `198.41.192.227` `198.41.192.47` `198.41.192.37` `198.41.192.77` | `2606:4700:a0::1` `2606:4700:a0::2` `2606:4700:a0::3` `2606:4700:a0::4` `2606:4700:a0::5` `2606:4700:a0::6` `2606:4700:a0::7` `2606:4700:a0::8` `2606:4700:a0::9` `2606:4700:a0::10` | 7844 | TCP/UDP (`http2`/`quic`) |

#### `region2.v2.argotunnel.com`

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| `198.41.200.13` `198.41.200.193` `198.41.200.33` `198.41.200.233` `198.41.200.53` `198.41.200.63` `198.41.200.113` `198.41.200.73` `198.41.200.43` `198.41.200.23` | `2606:4700:a8::1` `2606:4700:a8::2` `2606:4700:a8::3` `2606:4700:a8::4` `2606:4700:a8::5` `2606:4700:a8::6` `2606:4700:a8::7` `2606:4700:a8::8` `2606:4700:a8::9` `2606:4700:a8::10` | 7844 | TCP/UDP (`http2`/`quic`) |

#### `_v2-origintunneld._tcp.argotunnel.com`

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| Not applicable | Not applicable | 7844 | TCP (`http2`) |

This rule is only required for firewalls that enforce SNI.

#### `cftunnel.com`

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| Not applicable | Not applicable | 7844 | TCP/UDP (`http2`/`quic`) |

This rule is only required for firewalls that enforce SNI.

#### `h2.cftunnel.com`

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| Not applicable | Not applicable | 7844 | TCP (`http2`) |

This rule is only required for firewalls that enforce SNI.

#### `quic.cftunnel.com`

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| Not applicable | Not applicable | 7844 | UDP (`quic`) |

This rule is only required for firewalls that enforce SNI.

### Region US

When using the [US region](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/run-parameters/#region), ensure your firewall allows outbound connections to these US-region destinations on port `7844` (TCP/UDP) for tunnel operation.

#### `us-region1.v2.argotunnel.com`

| IPv4 | IPv6 | Port | Protocol |
| - | - | - | - |
| `198.41.218.1` `198.41.218.2` `198.41.218.3` `198.41.218.4` `198.41.218.5` `198.41.218.6` `198.41.218.7` `198.41.218.8` `198.41.218.9` `198.41.218.10` | `2606:4700:a1::1` `2606:4700:a1::2` `2606:4700:a1::3` `2606:4700:a1::4` `2606:4700:a1::5` `2606:4700:a1::6` `2606:4700:a1::7` `2606:4700:a1::8` `2606:4700:a1::9` `2606:4700:a1::10` | 7844 | TCP/UDP (`http2`/`quic`) |

#### `us-region2.v2.argotunnel.com`

| IPv4 | IPv6 | Port | Protocol |
| - | - | - | - |
| `198.41.219.1` `198.41.219.2` `198.41.219.3` `198.41.219.4` `198.41.219.5` `198.41.219.6` `198.41.219.7` `198.41.219.8` `198.41.219.9` `198.41.219.10` | `2606:4700:a9::1` `2606:4700:a9::2` `2606:4700:a9::3` `2606:4700:a9::4` `2606:4700:a9::5` `2606:4700:a9::6` `2606:4700:a9::7` `2606:4700:a9::8` `2606:4700:a9::9` `2606:4700:a9::10` | 7844 | TCP/UDP (`http2`/`quic`) |

### Optional

Opening port `443` enables some optional features. Failure to allow these connections may prompt a log error, but `cloudflared` will still run correctly.

#### `api.cloudflare.com`

Allows `cloudflared` to query if software updates are available.

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| `104.19.192.29` `104.19.192.177` `104.19.192.175` `104.19.193.29` `104.19.192.174` `104.19.192.176` | `2606:4700:300a::6813:c0af` `2606:4700:300a::6813:c01d` `2606:4700:300a::6813:c0ae` `2606:4700:300a::6813:c11d` `2606:4700:300a::6813:c0b0` `2606:4700:300a::6813:c0b1` | 443 | TCP (HTTPS) |

#### `update.argotunnel.com`

Allows `cloudflared` to query if software updates are available.

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| `104.18.25.129` `104.18.24.129` | `2606:4700::6812:1881` `2606:4700::6812:1981` | 443 | TCP (HTTPS) |

#### `github.com`

Allows `cloudflared` to download the latest release and perform a software update.

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| [GitHub's IPs](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/about-githubs-ip-addresses) | [GitHub's IPs](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/about-githubs-ip-addresses) | 443 | TCP (HTTPS) |

#### `<your-team-name>.cloudflareaccess.com`

Allows `cloudflared` to validate the Access JWT. Only required if the [`access`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/origin-parameters/#access) setting is enabled.

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| `104.19.194.29` `104.19.195.29` | `2606:4700:300a::6813:c31d` `2606:4700:300a::6813:c21d` | 443 | TCP (HTTPS) |

#### `pqtunnels.cloudflareresearch.com`

Allows `cloudflared` to report [post-quantum key exchange](https://blog.cloudflare.com/post-quantum-tunnel/) errors to Cloudflare.

| IPv4 | IPv6 | Port | Protocols |
| - | - | - | - |
| `104.18.4.64` `104.18.5.64` | `2606:4700::6812:540` `2606:4700::6812:440` | 443 | TCP (HTTPS) |

## Firewall configuration

### Cloud VM firewall

If you host your services on a virtual machine (VM) instance in a cloud provider, you may set up instance-level firewall rules to block all ingress traffic and allow only egress traffic. For example, on Google Cloud Platform (GCP), you may delete all ingress rules, leaving only the relevant egress rules. This is because GCP's firewall denies ingress traffic unless it matches an explicit rule.

### OS firewall

Alternatively, you may use operating system (OS)-level firewall rules to block all ingress traffic and allow only egress traffic. For example, if your server runs on Linux, you may use `iptables` to set up firewall rules:

1. Check your current firewall rules.

   ```sh
   sudo iptables -L
   ```

2. Allow `localhost` to communicate with itself.

   ```sh
   sudo iptables -A INPUT -i lo -j ACCEPT
   ```

3. Allow already established connection and related traffic.

   ```sh
   sudo iptables -A INPUT -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT
   ```

4. Allow new SSH connections.

   ```sh
   sudo iptables -A INPUT -p tcp --dport ssh -j ACCEPT
   ```

5. Drop all other ingress traffic.

   Warning

   Be very careful with the following command. If you did not preserve the current SSH connection or allow new SSH connections, you would be logged out and unable to SSH back into the system again.

   ```sh
   sudo iptables -A INPUT -j DROP
   ```

6. After setting the firewall rules, use this command to check the current `iptables` settings:

   ```sh
   sudo iptables -L
   ```

Run your tunnel and check that all configured services are still accessible to the outside world via the tunnel, but not via the external IP address of the server.

You can also [secure your application with Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/self-hosted-public-app/).

## Test connectivity

### Test with dig

To test your connectivity to Cloudflare, you can use the `dig` command to query the hostnames listed above. Note that `cloudflared` defaults to connecting with IPv4.

```sh
dig A region1.v2.argotunnel.com
```

```sh
;; ANSWER SECTION:
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.167
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.67
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.57
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.107
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.27
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.7
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.227
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.47
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.37
region1.v2.argotunnel.com. 86400 IN  A  198.41.192.77
...
```

```sh
dig AAAA region1.v2.argotunnel.com
```

```sh
...
;; ANSWER SECTION:
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::1
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::2
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::3
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::4
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::5
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::6
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::7
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::8
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::9
region1.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a0::10
...
```

```sh
dig A region2.v2.argotunnel.com
```

```sh
;; ANSWER SECTION:
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.13
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.193
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.33
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.233
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.53
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.63
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.113
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.73
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.43
region2.v2.argotunnel.com. 86400 IN  A  198.41.200.23
...
```

```sh
dig AAAA region2.v2.argotunnel.com
```

```sh
...
;; ANSWER SECTION:
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::1
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::2
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::3
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::4
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::5
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::6
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::7
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::8
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::9
region2.v2.argotunnel.com. 86400 IN  AAAA  2606:4700:a8::10
...
```

### Test with PowerShell

On Windows, you can use PowerShell commands if `dig` is not available.

To test DNS:

```powershell
Resolve-DnsName -Name _v2-origintunneld._tcp.argotunnel.com SRV
```

```txt
Name                                     Type   TTL   Section    NameTarget                     Priority Weight Port
----                                     ----   ---   -------    ----------                     -------- ------ ----
_v2-origintunneld._tcp.argotunnel.com       SRV    112   Answer     region2.v2.argotunnel.com         2        1      7844
_v2-origintunneld._tcp.argotunnel.com       SRV    112   Answer     region1.v2.argotunnel.com         1        1      7844
```

To test ports:

```powershell
tnc region1.v2.argotunnel.com -port 443
```

```txt
ComputerName     : region1.v2.argotunnel.com
RemoteAddress    : 198.41.192.227
RemotePort       : 443
InterfaceAlias   : Ethernet
SourceAddress    : 10.0.2.15
TcpTestSucceeded : True
```

```powershell
tnc region1.v2.argotunnel.com -port 7844
```

```txt
ComputerName     : region1.v2.argotunnel.com
RemoteAddress    : 198.41.192.227
RemotePort       : 7844
InterfaceAlias   : Ethernet
SourceAddress    : 10.0.2.15
TcpTestSucceeded : True
```
