---
title: Enable DNSSEC - subdomain setup · Cloudflare DNS docs
description: As opposed to the normal process for enabling DNSSEC, DNSSEC with a
  subdomain setup requires a few additional steps.
lastUpdated: 2025-10-23T07:57:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/dnssec/
  md: https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/dnssec/index.md
---

As opposed to the [normal process](https://developers.cloudflare.com/dns/dnssec/) for enabling DNSSEC, DNSSEC with a subdomain setup requires a few additional steps.

## Requirements

To use DNSSEC for a subdomain setup, DNSSEC must be enabled on the parent zone.

Ideally, you should also wait 12 to 24 hours after enabling DNSSEC on the parent zone to ensure DNS resolvers provide the same DNS query responses.

## Setup

1. [Create](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/setup/#how-to) the child zone.

2. Make sure the child zone is [active](https://developers.cloudflare.com/dns/zone-setups/reference/domain-status/) on Cloudflare and that DNS resolution is working properly for your subdomain.

3. [Enable DNSSEC](https://developers.cloudflare.com/dns/dnssec/) for the child zone and save the information provided within the DS record output.

4. On the [**DNS Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records) page of the parent zone, [add the DS record](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/) from the previous step.

   ![Screenshot showing how to add a DS record within Cloudflare](https://developers.cloudflare.com/_astro/ds-record-example.eCudbis6_Dbmwf.webp)

5. Add an A record to the child zone to validate DNS resolution.

6. Wait two to six hours. Then, [test the A record](https://developers.cloudflare.com/dns/dnssec/troubleshooting/#test-dnssec-with-dig) added in the previous step using multiple DNS resolvers with DNSSEC validation (`1.1.1.1`, `8.8.8.8`, and `9.9.9.9`). For example, if the A record is for `test.child.example.com`: `dig test.child.example.com +dnssec @1.1.1.1`.
