---
title: Brand Protection · Cloudflare Learning Paths
description: Brand Protection gives you the ability to search for new domains
  that may be attempting to impersonate your brand. Common misspellings
  (cloudfalre.com) and concatenation of services (cloudflare-okta.com) are often
  registered by attackers to trick unsuspecting victims into submitting private
  information such as passwords. Our system allows you to save search queries
  that run continuously and alert you if any new domains match those queries.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/application-security/security-center/brand-protection/
  md: https://developers.cloudflare.com/learning-paths/application-security/security-center/brand-protection/index.md
---

Brand Protection gives you the ability to search for new domains that may be attempting to impersonate your brand. Common misspellings (`cloudfalre.com`) and concatenation of services (`cloudflare-okta.com`) are often registered by attackers to trick unsuspecting victims into submitting private information such as passwords. Our system allows you to save search queries that run continuously and alert you if any new domains match those queries.

## Types of queries

1. [Domain search](https://developers.cloudflare.com/security-center/brand-protection/#domain-search): allows you to search for domains that might be trying to impersonate your brand.

2. [Logo search](https://developers.cloudflare.com/security-center/brand-protection/#logo-queries): allows you to search for logos that might look and feel like your brand's logo.

## Alerts

Brand Protection works with Cloudflare’s ANS (Alerts Notification Service) to provide configurable alerts when new domains are detected.

Any matches that are found during the new domain search are then inserted into an internal alerts table which triggers an alert for the user. This allows you to receive real-time notifications and take immediate action to investigate and potentially block any suspicious domains that may be attempting to impersonate your brand.
