---
title: Create allow policies · Cloudflare Learning Paths
description: Email Security allows you to configure allow policies. An allow
  policy exempts messages that match certain patterns from normal detection
  scanning.
lastUpdated: 2025-02-21T10:05:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-o365-email/configure-email-security/create-allow-policies/
  md: https://developers.cloudflare.com/learning-paths/secure-o365-email/configure-email-security/create-allow-policies/index.md
---

Email Security allows you to configure allow policies. An allow policy exempts messages that match certain patterns from normal detection scanning.

You can choose how Email Security will handle messages that match your criteria:

* **Trusted Sender**: Messages will bypass all [detections](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/) and link following. Typically, it only applies to phishing simulations from vendors such as KnowBe4. Many emails contain links in them. Some of these could be links to surveys, phishing simulations and other trackable links. By marking a message as a Trusted Sender, Email Security will not scan any attachments from the sender and will not attempt to open the links in the emails.
* **Exempt Recipient**: Messages will be exempt from all Email Security [detections](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/) intended for recipients matching this pattern (email address or regular expression only). Typically, this only applies to submission mailboxes for user reporting to security.
* **Accept Sender**: Messages will exempt messages from the `SPAM`, `SPOOF`, and `BULK` [dispositions](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/) (but not `MALICIOUS` or `SUSPICIOUS`). Commonly used for external domains and sources that send mail on behalf of your organization, such as marketing emails or internal tools.

## Configure allow policies

To configure allow policies:

1. Log in to [Zero Trust](https://one.dash.cloudflare.com/).

2. Select **Email Security**.

3. Select **Settings**, then go to **Detection settings** > **Allow policies**.

4. On the **Detection settings** page, select **Add a policy**.

5. On the **Add an allow policy** page, enter the policy information:

   * **Input method**: Choose between **Manual input**, and **Uploading an allow policy**:

     * **Manual input**:

       * **Action**: Select one of the following to choose how Email Security will handle messages that match your criteria:

         * **Trust sender**: Messages will bypass all detections and link following.
         * **Exempt recipient**: Message to this recipient will bypass all detections.
         * **Accept sender**: Messages from this sender will be exempted from Spam, Spoof, and Bulk dispositions.

     * **Rule type**: Specify the scope of your policy. Choose one of the following:

       * **Email addresses**: Must be a valid email.
       * **IP addresses**: Can only be IPv4. IPv6 and CIDR are invalid entries.
       * **Domains**: Must be a valid domain.
       * **Regular expressions**: Must be valid Java expressions. Regular expressions are matched with fields related to the sender email address (envelope from, header from, reply-to), the originating IP address, and the server name for the email.

     * **(Recommended) Sender verification**: This option enforces DMARC, SPF, or DKIM authentication. If you choose to enable this option, Email Security will only honor policies that pass authentication.
       * **Notes**: Provide additional information about your allow policy.

   * **Uploading an allow policy**: Upload a file no larger than 150 KB. The file can only contain `Pattern`, `Notes`, `Verify Email`, `Trusted Sender`, `Exempt Recipient`, and `Acceptable Sender` fields. The first row must be a header row.

6. Select **Save**.
