---
title: Additional configuration · Cloudflare Load Balancing docs
description: Beyond creating a simple load balancer, you may want to further
  customize how your load balancer routes traffic or integrate your load
  balancer with other Cloudflare products.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/additional-options/
  md: https://developers.cloudflare.com/load-balancing/additional-options/index.md
---

Beyond [creating a simple load balancer](https://developers.cloudflare.com/load-balancing/load-balancers/create-load-balancer/), you may want to further customize how your load balancer routes traffic or integrate your load balancer with other Cloudflare products.

## Customize load balancer behavior

* Route traffic according to characteristics of each request by [creating custom rules](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-rules/)
* Protect at-risk endpoints from reaching failover by [setting up load shedding](https://developers.cloudflare.com/load-balancing/additional-options/load-shedding/)
* Take endpoints out of rotation for [planned maintenance](https://developers.cloudflare.com/load-balancing/additional-options/planned-maintenance/)

## Integrate with other Cloudflare products

* Bring load balancing to your TCP or UDP applications with [Cloudflare Spectrum](https://developers.cloudflare.com/load-balancing/additional-options/spectrum/)
* Further secure endpoint access with [Cloudflare Tunnel](https://developers.cloudflare.com/load-balancing/additional-options/cloudflare-tunnel/)

## Integrate with 3rd parties

* Increase visibility by [sending health monitor notifications to PagerDuty](https://developers.cloudflare.com/load-balancing/additional-options/pagerduty-integration/)
