---
title: Monitor Groups · Cloudflare Load Balancing docs
description: Group multiple health monitors together to create sophisticated
  health checks for your applications, ensuring more intelligent and resilient
  traffic steering.
lastUpdated: 2025-10-16T08:42:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/monitors/monitor-groups/
  md: https://developers.cloudflare.com/load-balancing/monitors/monitor-groups/index.md
---

Group multiple health monitors together to create sophisticated health checks for your applications, ensuring more intelligent and resilient traffic steering.

You can group multiple health monitors to build sophisticated health checks that more accurately reflect your application's true health. A Monitor Group allows you to combine several independent monitors, define aggregation logic, and use the collective result to determine the health of an origin pool.

Grouping multiple health monitors enables more intelligent and resilient failover. For example, you can require that both a general API gateway monitor and a specific login service monitor must be healthy for a pool to receive traffic.

## Availability

Monitor Groups are only available to customers on an Enterprise plan with the Load Balancing subscription.

Configuration is available via the [API](https://developers.cloudflare.com/api/resources/load_balancers/subresources/monitor_groups/methods/create/) only.

Note

Pools assigned to a monitor group via the API will appear as **Not monitored** on the dashboard.

## How it works

When you attach a Monitor Group to a pool, the health of that pool is determined by aggregating the results of all enabled monitors within the group.

The sections below explain how monitor groups influence health status, latency, and result handling.

## Endpoint health with Monitor Groups

A Monitor Group determines an endpoint's health using a combination of critical monitor overrides and quorum-based consensus.

**Critical Monitor Override** (`must_be_healthy`): You can designate a monitor as critical by setting `"must_be_healthy": true`. If a monitor with this setting fails its health check against an endpoint, that specific endpoint is immediately marked as unhealthy. This happens regardless of the status reported by other monitors in the group for that same endpoint. This provides a definitive override for essential services.

**Quorum-Based Health**: In the absence of a failure from a `must_be_healthy` monitor, an endpoint's health is determined by a quorum of all other active monitors.

* An endpoint is considered unhealthy only if more than 50% of its assigned monitors report it as unhealthy.
* Monitors marked as `"monitoring_only": true` are excluded from the quorum calculation. They will still run and can trigger notifications, but they do not vote on the endpoint's health status.
* Monitors marked as `disabled` will not send monitoring requests to any associated pool. They are also excluded from the quorum calculation.

This quorum system prevents an endpoint from being prematurely marked as unhealthy due to a transient failure from a single, non-critical monitor.

## Latency for Steering

For pools using Dynamic Steering, the pool's latency is calculated as the average latency of all its enabled, non-monitoring-only monitors. This aggregated RTT (Round Trip Time) value provides a more holistic view of an origin's performance and is used to make steering decisions.

## Result handling for different intervals

If monitors in a group have different check intervals, the group uses the last available result from each monitor until it is refreshed. For example, if one monitor runs every 10 seconds and another every 30 seconds, the 30-second monitor's result is considered valid for the full 30 seconds until its next run completes.
