---
title: Secure access to SaaS applications with SASE · Cloudflare Reference
  Architecture docs
description: Cloudflare's SASE platform offers the ability to bring a more Zero
  Trust orientated approach to securing SaaS applications. Centralized policies,
  based on device posture, identity attributes and granular network location can
  be applied across one or many Saas applications.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/reference-architecture/diagrams/sase/secure-access-to-saas-applications-with-sase/
  md: https://developers.cloudflare.com/reference-architecture/diagrams/sase/secure-access-to-saas-applications-with-sase/index.md
---

## Introduction

SaaS applications have become essential tools in today's business operations. While SaaS applications reduce IT and infrastructure burden, they also introduce new security challenges that traditional architectures struggle to address. Many companies today are on the path to implementing a [Zero Trust architecture](https://zerotrustroadmap.org/), which heavily combines identity, device and network information to better secure applications.

However SaaS applications tend to focus their security on their own platform, such as storing data at rest in a secure manner and ensuring their applications are not exposing customer data due to application vulnerabilities. This document is going to cover how to address some of the limitations of SaaS applications by using Cloudflare's Secure Access Service Edge (SASE) platform. Specifically our Zero Trust Network Access (ZTNA) and Secure Web Gateway (SWG) services, combined with integrations to your existing identity and device security vendors.

## Is SaaS not already secure?

Before discussing the specifics of implementing SASE for SaaS applications, we should consider asking: is SaaS not already secure? Major providers like Salesforce, ServiceNow, Microsoft and more have implemented robust security capabilities, including integrations with identity providers for Single Sign On (SSO), SSL/TLS for all application communication, encryption of data at rest and comprehensive audit logs. Unfortunately, SaaS vendors are not attempting to rebuild entire security platforms in their applications, so they are not able to provide many features required for a modern Zero Trust architecture.

SaaS applications are unable to evaluate the security posture of connecting devices. A compromised laptop with valid credentials appears identical to a securely managed, corporate device. When data is downloaded from the SaaS application, it has no visibility into where it goes or if the device it is being downloaded to is secure. Typically authentication for SaaS applications is externalized by redirecting users to an identity service, therefore the SaaS application has no sense of how the user authenticated and as such all trust is placed in the identity provider.

These security challenges are compounded by poor network access controls — most SaaS applications accept connections from any Internet source, but sometimes they can be limited to only accessing from a specific set of IP addresses that might be associated with one or more physical offices. But these rudimentary network controls are hard to expand for remote users working from home, or partners and contractors who need access.

Cloudflare's SASE platform offers the ability to bring a more Zero Trust orientated approach to securing SaaS applications. Centralized policies, based on device posture, identity attributes and granular network location can be applied across one or many SaaS applications. Cloudflare becomes the new corporate network, and it is possible to gate access to Internet based SaaS applications to those users and devices that are connected to Cloudflare. Essentially it is a new corporate network in the cloud.

## Securing access with Cloudflare

The diagram below shows how Cloudflare sits between your users, devices and networks that require access to any SaaS application. The two main services proving security capabilities are:

* [Zero Trust Network Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/). Allows Cloudflare to become an identity proxy, so that you can easily enable authentication with a wide variety of identity providers to a single SaaS application. This service also incorporates the ability to evaluate access based on device posture and network location.
* [Secure Web Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/). Once all traffic to access the SaaS application flows through our gateway, HTTPS connections are terminated at Cloudflare and you have the ability to inspect the data flowing to and from the SaaS application. This allows you to block sensitive data from being exported to insecure locations.

![Figure 1: Only traffic that has passed the Cloudflare network and relevant policies is authorized to access the SaaS application.](https://developers.cloudflare.com/_astro/figure1.CyQmr5MZ_ZXUa9b.svg)

The above diagram shows the variety of ways in which traffic can on-ramp to Cloudflare, where the ZNTA service ensures authentication and the Secure Web Gateway filters both inbound and outbound traffic to/from the SaaS application.

1. Initial requests to the SaaS application are redirected to Cloudflare as part of SSO flow. ZTNA service authenticates users against existing identity providers.
2. A user, authenticated or not, is denied access to the SaaS application if their traffic is not sourced from Cloudflare.
3. A user on a non-managed device can use browser isolation, where the browser accessing the SaaS application runs on a Cloudflare server, and the results of the rendered page are securely delivered to a user's local browser.
4. A managed device is connected to Cloudflare using a secure tunnel and therefore all communication from device to SaaS application is filtered and secured.
   1. Cloudflare agent device posture can also be incorporated into authorizing traffic from these devices.
5. A device connected to a local network, where all Internet traffic is routed to Cloudflare via a secure Magic WAN tunnel, also ensures all traffic from network to SaaS application is filtered and secured.
6. Traffic then passes through our secure web gateway, where DNS and HTTP policies can be applied to traffic.
   1. HTTP policies allow the examination of the data being both uploaded and downloaded from the SaaS application using DLP profiles.
7. Traffic egresses Cloudflare with a specific IP. The SaaS application is configured to allow all traffic coming from that address.

XDR platform integrations

When integrating with an XDR platform such as Crowdstrike, Sentinel One or Microsoft Intune, device posture is also available for any authenticated user because Cloudflare matches the identity with the user in the XDR system and device posture information is evaluated.

## Example policy

The following is an example set of policies which demonstrate how you can use Cloudflare to secure access to Salesforce.

The first step is using an [egress IP policy under Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/). This allows you to purchase and assign specific IPs to users that have their traffic filtered via Gateway. Then in Salesforce, you enforce that access is only permitted for traffic with a source IP that matches the one in your egress policy. This combination ensures that the only way to get access to Salesforce is via Cloudflare.

| Egress Policy | |
| - | - |
| **Identity** | |
| User Group Names | All Employees |
| **Select Egress IP** | |
| Use dedicated Cloudflare Egress IPs | `203.0.113.88` |

This is important not only for securing access to Salesforce, but also for adequately protecting its contents while in use. Now let us examine the access policy that is limiting access to members of the Sales or Executives groups. We are also using our Crowdstrike integration to ensure that users are on company managed devices.

| Policy name | Account executives on trusted devices |
| - | - |
| Action | Allow |
| **Include** | |
| Member of group | Sales, Executives |
| **Require** | |
| Authentication method | MFA - multi-factor authentication |
| Gateway | On |
| Crowdstrike Service to Service | Overall Score above 80 |

This second policy applies to all employees but we are going to apply a few more steps before access is granted.

| Policy name | Employees on trusted devices |
| - | - |
| Action | Allow |
| **Include** | |
| Member of group | All Employees |
| **Require** | |
| Authentication method | MFA - multi-factor authentication |
| Gateway | On |
| Crowdstrike Service to Service | Overall Score above 80 |
| **Additional Settings** | |
| Purpose justification | On |
| Temporary authentication | On |
| Email addresses of approvers | `salesforce-admin@company.com` |

We are going to add in temporary authentication to this second policy. That means if Cloudflare determines that the incoming request is from someone outside of the Sales or Executives department, an administrator will need to explicitly grant them temporary access. In context, this policy could be used to secure access to Salesforce for employees outside the Sales department, as the customer information could be sensitive and confidential.

This approach is important for several reasons:

* It allows for human oversight on potentially risky access attempts, reducing the chance of unauthorized access through compromised or insecure devices.
* It provides flexibility for legitimate users to access the application even when their device fails to meet the highest security standards. This encourages users to maintain good security practices on their devices.
* In addition, since all user traffic is routed through Cloudflare, we can enforce additional security measures (such as preventing the download of sensitive data) via web traffic policies.

Cloudflare's SASE platform allows organizations to centralize security policy for accessing SaaS applications. It also enhances security by allowing you to leverage device posture and network attributes. You can configure it in a way where your SaaS application essentially is only accessible via your new corporate network which is built on Cloudflare.

## Related Resources

* [Evolving to a SASE architecture with Cloudflare](https://developers.cloudflare.com/reference-architecture/architectures/sase/)
* [Designing ZTNA access policies for Cloudflare Access](https://developers.cloudflare.com/reference-architecture/design-guides/designing-ztna-access-policies/)
* [Access to private apps without having to deploy client agents](https://developers.cloudflare.com/reference-architecture/diagrams/sase/sase-clientless-access-private-dns/)
