---
title: Auth with headers · Cloudflare Rules docs
description: Allow or deny a request based on a known pre-shared key in a
  header. This is not meant to replace the [WebCrypto
  API](/workers/runtime-apis/web-crypto/).
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Authentication,Request modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/
  md: https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/index.md
---

Caution when using in production

The example code contains a generic header key and value of `X-Custom-PSK` and `mypresharedkey`. To best protect your resources, change the header key and value in the Snippets editor before saving your code.

```js
export default {
  async fetch(request) {
    /**
     * @param {string} PRESHARED_AUTH_HEADER_KEY Custom header to check for key
     * @param {string} PRESHARED_AUTH_HEADER_VALUE Hard-coded key value
     */
    const PRESHARED_AUTH_HEADER_KEY = "X-Custom-PSK";
    const PRESHARED_AUTH_HEADER_VALUE = "mypresharedkey";
    const psk = request.headers.get(PRESHARED_AUTH_HEADER_KEY);


    if (psk === PRESHARED_AUTH_HEADER_VALUE) {
      // Correct preshared header key supplied. Fetch request from origin.
      return fetch(request);
    }


    // Incorrect key supplied. Reject the request.
    return new Response("Sorry, you have supplied an invalid key.", {
      status: 403,
    });
  },
};
```
