---
title: Bulk redirect based on a map object · Cloudflare Rules docs
description: Redirect requests to certain URLs based on a mapped object to the
  request's URL.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Redirects
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/bulk-redirect-map/
  md: https://developers.cloudflare.com/rules/snippets/examples/bulk-redirect-map/index.md
---

```js
export default {
  async fetch(request) {
    // Define a variable with the hostname that needs to be redirected.
    const externalHostname = "example.com";


    // Define the map object. Replace the sources (/pathX) and targets (/redirectX) with ones that apply to your case.
    const redirectMap = new Map([
      ["/path1", "https://" + externalHostname + "/redirect1"],
      ["/path2", "https://" + externalHostname + "/redirect2"],
      ["/path3", "https://" + externalHostname + "/redirect3"],
      ["/path4", "https://cloudflare.com"],
    ]);


    // Clone the original URL.
    const requestURL = new URL(request.url);


    // Check the request path against the map and redirect accordingly.
    const path = requestURL.pathname;
    const location = redirectMap.get(path);


    if (location) {
      return Response.redirect(location, 301);
    }


    // If request path not in map, return the original request.
    return fetch(request);
  },
};
```
