---
title: Writing guidelines · Cloudflare Style Guide
description: Use the following writing guidelines to create product content that
  is clear and consistent and demonstrates Cloudflare's brand voice and product
  tone. The tone we use varies based on customer goals while using certain
  products and features. We emphasize ease-of-use within our products.
lastUpdated: 2025-10-21T17:26:45.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/writing-guidelines/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/writing-guidelines/index.md
---

Use the following writing guidelines to create product content that is clear and consistent and demonstrates Cloudflare's brand voice and product tone. The tone we use varies based on customer goals while using certain products and features. We emphasize ease-of-use within our products.

## Use plain language

Plain language is writing that an audience can understand and act upon the first time they read it. Using plain language ensures your audience understands what you mean. Cloudflare users are a global audience whose first language might not be English. Plain language makes translation easier and documentation more accessible.

Consider the following tips for using plain language in your writing:

* Put important messages in the beginning.
* Avoid obscure words.
* Use simple sentences. One sentence should be one idea.
* Avoid abbreviations.
* Be consistent.

For more information about plain language, refer to the [Plain Language Guide Series](https://digital.gov/guides/plain-language).

***

## Prioritize the customer

Center your content around customer objectives rather than Cloudflare’s business objectives. Write with the objective first, then the action.

***

## Provide information as needed

Keep the information given pertinent to the particular point in the user’s journey. Make sure to define or give more context for any metrics provided.

Do not list performance statistics in feature descriptions.

***

## Communicate confidently

Use a confident and clear tone that prevents customer doubt. Guide from a place of expertise without talking down to the audience.

***

## Avoid jargon and technical language

Communicate concepts without using jargon. Replace it if possible. Define acronyms and technical terms. Refer to the table for examples of how to translate jargon into plain language:

| Jargon | Plain language |
| - | - |
| Do a `GET`. | Submit a `GET` request. |
| Use the out-of-the-box settings. | Use the default settings. |
| You can deploy Cloudflare Enterprise services on-prem. | You can deploy Cloudflare Enterprise services on-premises. |
| Perform an execution of the process steps with a core focus of ensuring that the deployments do not conflict. | Make sure that no deployments conflict with one another. |

Consider the following to help you avoid jargon in your writing:

* Consider your audience's level of knowledge.
* Consider if the user needs to know the term to complete a task or understand the documentation.

***

## Use active voice and present tense

Active voice is more concise and direct than passive voice and should be used whenever possible. Make the message clear and comprehensible to anyone using Cloudflare's products. Choose clarity over concise copy.

| Do | Don't | Rationale |
| - | - | - |
| Cloudflare Load Balancing **automatically reduces** latency by directing visitors to infrastructure closest to them. | Latency is **automatically reduced** by Cloudflare Load Balancing. Visitors are directed to infrastructure closest to them. | Writing this sentence in the active voice shifts the focus from the pain point (latency) to the solution (Cloudflare Load Balancing). |
| Now, paired with the HTML Rewriter API, **you can perform DOM transformations** on top of your static HTML. | Now, paired with the HTML Rewriter API, **DOM transformations can be performed** on top of your static HTML. | Writing this sentence in the active voice shifts the focus from the product to the customer. |

Use present tense verbs. Avoid past tense whenever possible, as it can quickly make content feel outdated or irrelevant. Future tense should only be applied to actions that have not happened yet.

| Do | Don't | Rationale |
| - | - | - |
| FindLaw **uses** Cloudflare to accelerate and secure thousands of customer sites. | FindLaw **used** Cloudflare to accelerate and secure thousands of customer sites. | FindLaw is a current customer who still benefits from the performance and security Cloudflare provides, so we should refer to them in the present tense. |

***

## Be solutions-oriented

Focus on solving problems. Anticipate customer problems to write with solutions in mind and embedded in the interface.

***

## Write accessible documentation

Use the guidelines below to create product content that is more accessible to people with disabilities. These tips are good practice to help you meet Web Content Accessibility Guidelines (WCAG) requirements:

* Provide informative, unique page titles.
* Use headings to convey meaning and structure.
* Make the link text meaningful.
* Writing meaningful text alternatives (alt text) for images.
* Create transcripts and captions for multimedia.
* Provide clear instructions.
* Keep content clear and concise.

Refer to [Writing for Web Accessibility](https://www.w3.org/WAI/tips/writing/) for additional information about WCAG requirements, detailed background, user stories, and more.

***

## Write clear and concise sentences

Use simple language and formatting, as appropriate for the context. Respect our users’ time.

* Keep sentences between 8 to 12 words.
* Write in short, clear sentences and paragraphs.
* Avoid using unnecessarily complex words and phrases.
* Expand acronyms on the first use. For example, Web Content Accessibility Guidelines (WCAG).
* Consider providing a glossary for terms readers may not know.
* Use list formatting as appropriate.
* Consider using images, illustrations, video, and symbols to help clarify meaning or when a written description is unintuitive.

## Use consistent terminology

Apply the same unambiguous word or term consistently throughout a document.

## Clarify gerunds and participles

Participles are verbs that end in *-ed* or *-ing* and act as modifiers. Gerunds are verbs that end in *-ing* and act as nouns. Both types of words are useful and acceptable, but they can cause confusion if they are misplaced in a sentence. For example, the word meeting can be a gerund or a participle (or even a noun) depending on its placement in a sentence. When you use gerunds and participles, ensure that the meaning is clear.

| Do | Don't |
| - | - |
| A job can include **metadata that schedules** the program to run at a specified date and time. | A job can include **scheduling metadata** that enables the program to run at a specified date and time. |
| Public Cloud is infrastructure **that consists** of shared resources, deployed on a self-service basis over the Internet. | Public Cloud is infrastructure **consisting** of shared resources, deployed on a self-service basis over the Internet. |
| Test the certificate **by using** a browser to connect to your server. | Test the certificate **using** a browser to connect to your server. |
| When **you use** a load balancer with a public-facing IP address, this address becomes the IP address of your website. | When **using** a load balancer with a public-facing IP address, this address becomes the IP address of your website. |

The last example illustrates a dangling modifier. In the "Don't" example, *using* does not have a subject, so the implied subject is address, which is incorrect. If the implied subject is not correct, you must revise the sentence to provide a subject for the modifying phrase.

The titles of tutorial or high-level process articles or topics typically start with a gerund. Titles have less context than sentences, so you must be especially careful to ensure that the meaning is clear.

| Do | Don't |
| - | - |
| Options for editing *or* Editing of options | Editing options |
| Billing for services | Billing services |
| Changing the DNS settings on Windows | Changing DNS settings on Windows |
| Changing a password | Changing passwords |

***

## Write for internationalization (I18n)

Cloudflare has a global customer base. To be inclusive of all our customers and make the process of internationalization smoother, consider certain guidelines for content that is meant to be translated. In addition to all our general product writing guidelines, use the following guidelines to ensure what you write is localization-friendly.

* Write clearly: An unclear message is difficult to translate, if not impossible. If it is not clear in English, it will not be clear in any other language.
* Avoid cultural references: Specific cultural references only make sense to the locale you are writing from or a small subset of our customers, so do not use them in product or documentation.
* Do not use contractions: Even with space constraints, do not use contractions. They are specific to English and difficult to translate.
* Give definitions and contextual information: Never use a technical term or acronym without defining it. For terms that are not translatable, information and context matter.

***

## Write inclusive documentation

Write documentation with inclusivity and diversity in mind. Here are some general guidelines and examples that illustrate some best practices to follow.

The language we use to describe and discuss our products, features, and processes is important. Whether we are writing a blog post, leading a webinar, or developing a campaign, our goal is always to create inclusive content that speaks to our global, diverse audience. We do not use racist, gendered, or ableist terminology.

In addition to the guidelines outlined below, we have identified and replaced several industry-related terms which can be offensive or painful to people from certain backgrounds, cultures, and/or creeds.

Do not use terms that are rooted in racism. We do not use terms that describe good outcomes and actions as "white" and bad actions or outcomes as "black" (such as whitehat/blackhat hacker) nor do we use common industry terms that stem from language used to describe slavery (such as master/slave).

| Do | Don't | Rationale |
| - | - | - |
| Many search engines will **block** your site if you are hosting malicious content, which only compounds the issue for site owners that do not know that they have been compromised. | Many search engines will **blacklist** your site if you are hosting malicious content, which only compounds the issue for site owners that do not know that they have been compromised. | Since we do not want to use "black" to refer to a negative action here, we replace the term "blacklist" with a neutral, descriptive term that clearly explains the action that is being performed (in this case, "block"). |

Replace gendered terms with non-gendered terms. Gendered language may be used when referring to specific people with known pronouns. It is unnecessary when discussing products and technical processes — for instance, referring to a hypothetical attacker as "he" or a piece of hardware as "she."

| Do | Don't | Rationale |
| - | - | - |
| One type of attack that could trigger a browser warning is a so-called **on-path** attack. In this attack, an attacker places **themselves** in between a visitor and a website, impersonating both. | One type of attack that could trigger a browser warning is a so-called **man-in-the-middle (MitM)** attack. In this attack, an attacker places **himself** in between a visitor and a website, impersonating both. | Because a "man-in-the-middle attack" is a term, not a reference to a specific attack carried out by a man, we opt for the term "on-path attack" and attach gender-neutral they/them pronouns when describing the attacker. |

Avoid ableist terms and metaphors. This does not just apply to industry terms, but to descriptors like "crazy" and "insane," which reinforce negative, ableist stereotypes.

| Do | Don't | Rationale |
| - | - | - |
| As Workers use cases grow in complexity, the need to **validate** your code also grows. | As Workers use cases grow in complexity, the need to **sanity check** your code also grows. | We avoid metaphorical terms that reference mental health, like "sanity check," and replace them with words that more accurately describe the process taking place (in this case, "validate", though "smoke test" is also an approved replacement). |

***

## Define new and unfamiliar terms

When writing or editing, recognize terms that might be unfamiliar to some or all of the audience. When you spot a such a term, take one of the following tactics:

* If the term already exists, link to a good existing explanation.
* If your document is introducing the term, define the term.

***

## Use short, familiar words and phrases

Words that are conversational, save space, and are easier to scan are often easier to read for non-native English speakers. Long words or phrases may be necessary to convey a particular meaning, but should be used sparingly.

***

## Follow web standards

To effectively communicate online, you need to follow web standards, design for reading, and repurpose print materials for the web. For more information about web standards, refer to the [Plain Language Guide Series](https://digital.gov/guides/plain-language).
