---
title: Challenge bad bots · Cloudflare Web Application Firewall (WAF) docs
description: Cloudflare's Bot Management feature scores the likelihood that a
  request originates from a bot.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/challenge-bad-bots/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/challenge-bad-bots/index.md
---

Cloudflare's Bot Management feature scores the likelihood that a request originates from a bot.

Note

Access to [Bot Management](https://developers.cloudflare.com/bots/plans/bm-subscription/) requires a Cloudflare Enterprise plan with Bot Management enabled.

Bot score ranges from 1 through 99. A low score indicates the request comes from a script, API service, or an automated agent. A high score indicates that a human issued the request from a standard desktop or mobile web browser.

These examples use:

* [`cf.bot_management.score`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.bot_management.score/) to target requests from bots
* [`cf.bot_management.verified_bot`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.bot_management.verified_bot/) to identify requests from [known good bots](https://radar.cloudflare.com/verified-bots)
* [`cf.bot_management.ja3_hash`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.bot_management.ja3_hash/) to target specific [JA3 Fingerprints](https://developers.cloudflare.com/bots/additional-configurations/ja3-ja4-fingerprint/)

## Suggested rules

For best results:

* Use [Bot Analytics](https://developers.cloudflare.com/bots/bot-analytics/#enterprise-bot-management) to learn about your traffic before applying rules.
* Start small and increase your bot threshold over time.

Your rules may also vary based on the [nature of your site](https://developers.cloudflare.com/bots/get-started/bot-management/) and your tolerance for false positives.

### General protection

The following three custom rules provide baseline protection against malicious bots:

**Rule 1:**

* **Expression**: `(cf.bot_management.verified_bot)`
* **Action**: *Skip:*
  * *All remaining custom rules*

**Rule 2:**

* **Expression**: `(cf.bot_management.score eq 1)`
* **Action**: *Block*

**Rule 3:**

* **Expression**: `(cf.bot_management.score gt 1 and cf.bot_management.score lt 30)`
* **Action**: *Managed Challenge*

### Specific protection for browser, API, and mobile traffic

#### Protect browser endpoints

When a request is definitely automated (score of 1) or likely automated (scores 2 through 29) and is *not* on the list of known good bots, Cloudflare blocks the request.

* **Expression**: `(cf.bot_management.score lt 30 and not cf.bot_management.verified_bot)`
* **Action**: *Block*

#### Exempt API traffic

Since Bot Management detects automated users, you need to explicitly allow your **good** automated traffic⁠ — this includes your [APIs](https://www.cloudflare.com/learning/security/api/what-is-an-api/) and partner APIs.

This example offers the same protection as the browser-only rule, but allows automated traffic to your API.

* **Expression**: `(cf.bot_management.score lt 30 and not cf.bot_management.verified_bot and not starts_with(http.request.uri.path, "/api"))`
* **Action**: *Block*

#### Adjust for mobile traffic

Since Bot Management can be more sensitive to mobile traffic, you may want to add in additional logic to avoid blocking legitimate requests.

If you are handling requests from your own mobile application, you could potentially allow it based on its specific [JA3 fingerprint](https://developers.cloudflare.com/bots/additional-configurations/ja3-ja4-fingerprint/).

* **Expression**: `(cf.bot_management.ja3_hash eq "df669e7ea913f1ac0c0cce9a201a2ec1")`
* **Action**: *Skip:*
  * *All remaining custom rules*

Otherwise, you could set lower thresholds for mobile traffic. The following rules would block definitely automated mobile traffic and challenge likely automated traffic.

**Rule 1:**

* **Expression**: `(cf.bot_management.score lt 2 and http.user_agent contains "App_Name 2.0")`
* **Action**: *Block*

**Rule 2:**

* **Expression**: `(cf.bot_management.score lt 30 and http.user_agent contains "App_Name 2.0")`
* **Action**: *Managed Challenge*

#### Combine the different rules

If your domain handles mobile, browser, and API traffic, you would want to arrange these example rules in the following order:

* Rule for [API traffic](#exempt-api-traffic)
* Rule(s) for [mobile traffic](#adjust-for-mobile-traffic)
* Rule for [browser traffic](#protect-browser-endpoints)

### Static resource protection

Static resources are protected by default when you create custom rules using the `cf.bot_management.score` field.

To exclude static resources, include `not (cf.bot_management.static_resource)` in your rule expression. For details, refer to [Static resource protection](https://developers.cloudflare.com/bots/additional-configurations/static-resources/).

### Additional considerations

From there, you could customize your custom rules based on specific request paths (`/login` or `/signup`), common traffic patterns, or many other characteristics.

Make sure you review [Bot Analytics](https://developers.cloudflare.com/bots/bot-analytics/#enterprise-bot-management) and [Security Events](https://developers.cloudflare.com/waf/analytics/security-events/) to check if your rules need more tuning.

***

## Other resources

* [Use case: Allow traffic from verified bots](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-verified-bots/)
* [Tutorial: Integrate Turnstile, WAF, and Bot Management](https://developers.cloudflare.com/turnstile/tutorials/integrating-turnstile-waf-and-bot-management/)
